unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DXFImage, DXFConv, DB, DBTables, ExtCtrls, StdCtrls, Mask, DBCtrls,
  ExtDlgs
  {$IFNDEF sgDXFONLY}
  ,DWG, HPGL2, SVG, CGM
  {$ENDIF};

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBEdit1: TDBEdit;
    Label1: TLabel;
    Table1: TTable;
    Table1ID: TAutoIncField;
    Table1FILE_NAME: TStringField;
    Table1CAD: TBlobField;
    Button1: TButton;
    OpenPictureDialog1: TOpenPictureDialog;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure Table1AfterScroll(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenPictureDialog1.Filter := GraphicFilter(TGraphic);
  with Table1 do
  begin
    Active := False;
    TableType := ttParadox;
    TableName := 'demo';
    if not Exists then
    begin
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do begin
          Name := 'ID';
          DataType := ftAutoInc;
          Required := True;
        end;
        with AddFieldDef do begin
          Name := 'FILE_NAME';
          DataType := ftString;
        end;
        with AddFieldDef do begin
          Name := 'CAD';
          DataType := ftBlob;
        end;
      end;
      CreateTable;
    end;
  end;
  Table1.Open;
end;

procedure TForm1.Table1AfterScroll(DataSet: TDataSet);
const
  Exts: array[0..18] of string = ( '.dxf', '.dwg', '.plt', '.hgl', '.rtl',
    '.hg', '.plo', '.hp', '.hp1', '.hp2', '.hpg', '.hpgl', '.hpgl2', '.gl2',
    '.prn', '.spl', '.svg', '.svgz', '.cgm');
var
  Stream : TStream;
  vFileExt: string;
  Img: TsgDXFImage;
begin
  Stream := Table1.CreateBlobStream(Table1.FieldByName('CAD'), bmRead);
  try
    vFileExt := ExtractFileExt(Table1.FieldByName('FILE_NAME').AsString);
    case StrIndex(vFileExt, Exts) of
      0:	Img := TsgDXFImage.Create;
      {$IFNDEF sgDXFONLY}
      1:	Img := TsgDWGImage.Create;
      2..15:	Img := TsgHPGLImage.Create;
      16, 17:     Img := TsgSVGImage.Create;
      18:     Img := TsgCGMImage.Create;
      {$ENDIF}
      else	Img := nil;
    end;
    if Img <> nil then
    begin
      Img.LoadFromStream(Stream);
      Image1.Picture.Assign(Img);
    end
    else
      Image1.Picture.Graphic := nil;
  finally
    Img.Free;
    Stream.Free;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  begin
    if (Table1.State <> dsEdit) or (Table1.State <> dsInsert) then
      Table1.Edit;
    DBEdit1.Text := ExtractFileName(OpenPictureDialog1.FileName);
    Table1CAD.LoadFromFile(OpenPictureDialog1.FileName);
    Table1.Post;
  end;
end;

end.
